/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NetherBeehiveDecorator
extends TreeDecorator {
    public static final Codec<NetherBeehiveDecorator> CODEC = RecordCodecBuilder.create(configurationInstance -> configurationInstance.group((App)Codec.FLOAT.fieldOf("probability").orElse((Object)Float.valueOf(0.0f)).forGetter(configuration -> Float.valueOf(configuration.probability))).apply((Applicative)configurationInstance, NetherBeehiveDecorator::new));
    private static final Direction WORLDGEN_FACING = Direction.SOUTH;
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().filter(direction -> direction != WORLDGEN_FACING.m_122424_()).toArray(Direction[]::new);
    public final float probability;
    private BlockState nest;

    public NetherBeehiveDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)ModFeatures.NETHER_BEEHIVE.get();
    }

    public void setNest(BlockState nest) {
        this.nest = nest;
    }

    public void m_142741_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random random, List<BlockPos> pLogPositions, List<BlockPos> pLeafPositions) {
        if (!(random.nextFloat() >= this.probability) && this.nest != null) {
            int i = !pLeafPositions.isEmpty() ? Math.max(pLeafPositions.get(0).m_123342_() - 1, pLogPositions.get(0).m_123342_() + 1) : Math.min(pLogPositions.get(0).m_123342_() + 1 + random.nextInt(3), pLogPositions.get(pLogPositions.size() - 1).m_123342_());
            List list = pLogPositions.stream().filter(pos -> pos.m_123342_() == i).flatMap(pos -> Stream.of(SPAWN_DIRECTIONS).map(arg_0 -> ((BlockPos)pos).m_142300_(arg_0))).collect(Collectors.toList());
            if (!list.isEmpty()) {
                Collections.shuffle(list);
                Optional<BlockPos> optional = list.stream().filter(pos -> Feature.m_65810_((LevelSimulatedReader)pLevel, (BlockPos)pos) && Feature.m_65810_((LevelSimulatedReader)pLevel, (BlockPos)pos.m_142300_(WORLDGEN_FACING))).findFirst();
                if (optional.isPresent()) {
                    Direction facing = WORLDGEN_FACING;
                    for (Direction d : Direction.Plane.HORIZONTAL) {
                        if (!pLogPositions.contains(optional.get().m_142300_(d))) continue;
                        facing = d.m_122424_();
                        break;
                    }
                    pBlockSetter.accept(optional.get(), (BlockState)this.nest.m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)facing));
                    pLevel.m_141902_(optional.get(), (BlockEntityType)ModTileEntityTypes.NETHER_BEE_NEST.get()).ifPresent(blockEntity -> {
                        int j = 2 + random.nextInt(2);
                        String type = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.nest.m_60734_()).m_135815_().equals("warped_bee_nest") ? "warped" : "crimson";
                        for (int k = 0; k < j; ++k) {
                            try {
                                CompoundTag bee = TagParser.m_129359_((String)("{id:\"productivebees:configurable_bee\",bee_type: \"hive\", bee_temper: 1, bee_behavior: 1, type: \"productivebees:" + type + "\", bee_endurance: 2, bee_weather_tolerance: 0, bee_productivity: 1, HasConverted: false}"));
                                blockEntity.addBee(bee, random.nextInt(599), 600, null, new TranslatableComponent("entity.productivebees." + type + "_bee").getString());
                                continue;
                            }
                            catch (CommandSyntaxException e) {
                                ProductiveBees.LOGGER.warn("Failed to put bees into nether nest :(" + e.getMessage());
                            }
                        }
                    });
                }
            }
        }
    }
}

